﻿<%@ Page Language="c#" CodePage="1200" %>

<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>

<%@ Import Namespace="System.ComponentModel" %>
<%@ Import Namespace="System.Collections.Generic" %>
<%@ Import Namespace="System.Diagnostics" %>
<%@ Import Namespace="Soneta.CRM" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Ksiega" %>
<%@ Import Namespace="Soneta.Kasa" %>
<%@ Import Namespace="Soneta.Waluty" %>
<%@ Import Namespace="Soneta.Kasa.Forms" %>



<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
	<head>
		<title>Struktura wiekowa należności - dokumenty</title>
		<script runat="server">
	
		//
		// KONFIGURACJA RAPORTU
		//

		// 
		// - nazwa cechy kontrahenta        
		// - nazwa słownika 
		// - etykieta wyświetlana podczas pytania o wartość pola
		// 

		private const String wgWartościCechy = "Kategoria";
		private const String wgWartościDictionary = "F.Kategoria";
		private const String wgWartościLabel = "Kategoria";

		//
		// Podział na strefy
		// W przypadku modyfikacji w tablicy okresy należy wpisać kolejne wartości graniczne	
		//
		private static readonly int[] okresy = new int[] { 30, 60, 90, 180, 365 };

		//
		// PARAMETERS
		//

		public enum Zakres
		{ Razem, Kontrahenci, Pracownicy, Urzędy }

		public enum TypDokumentow
		{ Zobowiązania, Należności, PerSaldo }

		public enum TypRozliczen
		{
            [Caption("wg rozrachunków")]
            Kasowe,
            [Caption("wg kont")]
            Księgowe
        }



		public class PrnParams : Soneta.Business.OkresContext
		{
			private FromTo okresKS;
			private Zakres zakres = Zakres.Kontrahenci;
			private TypRozliczen typRozliczen = TypRozliczen.Kasowe;
			private IPodmiotKasowy odk;
			private IPodmiotKasowy dok;
			private String wartośćCechy = String.Empty;
			private TypDokumentow dokumenty = TypDokumentow.Należności;
			private RodzajDokumentów rodzaj = RodzajDokumentów.Razem;
			private Boolean wgWartosciPLNHist;
			private Waluta waluta;
			private String aktualneKonto = String.Empty;
			

			public PrnParams(Context context)
				: base(context)
			{
				this.waluta = WalutyModule.GetInstance(this).Waluty.PLN;
				this.Okres = FromTo.All;
				this.okresKS = FromTo.All;
			}


			protected override void Accept()
			{
				Session.Verifiers.Add(new WeryfikatorWaluty(this));
				base.Accept();
			}


			[Priority(10)]
			public override Date Aktualny
			{
				get { return base.Aktualny; }
				set { base.Aktualny = value; }
			}


			[Priority(15)]
			[Caption("Typ rozliczeń")]
			public TypRozliczen TypRozliczen
			{
				get { return typRozliczen; }
				set
				{
					typRozliczen = value;
					OnChanged();
				}
			}


			[Priority(20)]
			public override FromTo Okres
			{
				get { return base.Okres; }
				set
				{
					base.Okres = value != FromTo.Empty ? value : FromTo.All;
					OnChanged();
				}
			}


			[Priority(30)]
			[Caption("Okres księgowy")]
			public FromTo OkresKS
			{
				get { return okresKS; }
				set
				{
					okresKS = value != FromTo.Empty ? value : FromTo.All;
					OnChanged();
				}
			}


			[Priority(140)]
			public Zakres Zakres
			{
				get { return zakres; }
				set
				{
					if ((zakres = value) != Zakres.Kontrahenci)
						wartośćCechy = String.Empty;
					OnChanged();
				}
			}


			[Priority(150)]
			[Caption("Od kontrahenta")]
			public IPodmiotKasowy Od
			{
				get { return odk; }
				set
				{
					odk = value;
					OnChanged();
				}
			}


			[Priority(160)]
			[Caption("Do kontrahenta")]
			public IPodmiotKasowy Do
			{
				get { return dok; }
				set
				{
					dok = value;
					OnChanged();
				}
			}


			[Priority(170)]
			[Caption(wgWartościLabel)]
			[Browsable(wgWartościLabel != "")]
			[Dictionary(wgWartościDictionary)]
			public String WartośćCechy
			{
				get { return wartośćCechy; }
				set
				{
					wartośćCechy = value;
					OnChanged();
				}
			}


			public Boolean IsReadOnlyWartośćCechy()
			{ return wgWartościCechy == "" || zakres != Zakres.Kontrahenci; }


			[Priority(180)]
			public TypDokumentow Dokumenty
			{
				get { return dokumenty; }
				set
				{
					dokumenty = value;
					OnChanged();
				}
			}


			[Priority(190)]
			[Caption("Rodzaj")]
			public RodzajDokumentów Rodzaj
			{
				get { return rodzaj; }
				set
				{
					rodzaj = value;
					OnChanged();
				}
			}


			[Priority(200)]
			[Caption("Wg wartości PLNHist")]
			public Boolean WgWartosciPLNHist
			{
				get { return wgWartosciPLNHist; }
				set
				{
					wgWartosciPLNHist = value;
					OnChanged();
				}
			}


			[Priority(210)]
			public Waluta Waluta
			{
				get { return waluta; }
				set
				{
					waluta = value;
					OnChanged();
				}
			}


			[Priority(220)]
			public String AktualneKonto
			{
				get { return aktualneKonto; }
				set
				{
					aktualneKonto = value.ToUpper();
					OnChanged();
				}
			}
		}
		

		[Context(Required = true)]
		public PrnParams Params
		{
			get { return pars; }
			set { pars = value; }
		}


	    [Context(Required = true)]
	    public WydrukOddzialParams OParams { get; set; }


		//
		// WERYFIKATOR WALUTY
		//

		public class WeryfikatorWaluty : Verifier
		{
			readonly PrnParams data;
			bool active = false;

			public WeryfikatorWaluty(PrnParams data)
			{ this.data = data; }

			public override VerifierType Type
			{ get { return VerifierType.Error; } }

			public override String Description
			{ get { return "Podaj walutę jeśli zestawienie nie jest robione wg wartości PLNHist."; } }

			protected override Boolean IsValid()
			{ return data.Waluta != null || data.WgWartosciPLNHist; }

			public override Object Source
			{ get { return this.data; } }

			protected override bool IsAccept(object data, string property, VerifierAction action)
			{
				if (action == VerifierAction.AcceptRow) active = true;
				return active && data == this.data && property == "Waluta";
			}

			public override bool Equals(object v)
			{ return GetType() == v.GetType() && data == ((WeryfikatorWaluty)v).data; }

			public override int GetHashCode()
			{ return data.GetHashCode(); }
		}


		//
		// LOCAL VARIABLES
		//


		private PrnParams pars = null;
		private WydrukiRozrachunkowFiltr wr = new WydrukiRozrachunkowFiltr();

		
		private class IdxProxy: IComparable <IdxProxy>
		{
			private readonly RozrachunekIdx idx;
			private readonly Date termin;
			private readonly int zwłoka;
			private readonly decimal pozostaje;
			private readonly decimal kwotadokumentu;


			internal IdxProxy(RozrachunekIdx idx, StanRozliczeniaRozrachunkuWorker worker, PrnParams prms)
			{
				this.idx = idx;

				if (prms.TypRozliczen == TypRozliczen.Kasowe)
				{
					this.termin = idx.Termin;
					this.zwłoka = idx.ZwłokaNaDzień(prms.Aktualny);
					Currency kwotaCalosc = prms.WgWartosciPLNHist ? worker.KwotaKsiegi_NotReversed : worker.Kwota_NotReversed;

					decimal kwotaZob = prms.WgWartosciPLNHist ? worker.ZobowiazaniePLNHist(prms.Aktualny).Value : worker.Zobowiazanie(prms.Aktualny).Value;
					decimal kwotaNal = prms.WgWartosciPLNHist ? worker.NaleznoscPLNHist(prms.Aktualny).Value : worker.Naleznosc(prms.Aktualny).Value;

					switch (prms.Dokumenty)
					{
						case TypDokumentow.Należności:
							this.pozostaje = kwotaNal;
							this.kwotadokumentu = worker.PrzeliczWgZnaku(worker.NaleznoscSign(), delegate() { return kwotaCalosc; }, kwotaCalosc.Symbol).Value;
							break;

						case TypDokumentow.Zobowiązania:
							this.pozostaje = kwotaZob;
							this.kwotadokumentu = worker.PrzeliczWgZnaku(worker.ZobowiazanieSign(), delegate() { return kwotaCalosc; }, kwotaCalosc.Symbol).Value;
							break;

						default:
							this.pozostaje = kwotaNal - kwotaZob;
							this.kwotadokumentu = worker.PrzeliczWgZnaku(worker.NaleznoscSign() - worker.ZobowiazanieSign(), delegate() { return kwotaCalosc; }, kwotaCalosc.Symbol).Value;
							break;
					}
				}
				else
				{
					this.termin = idx.Termin;
					this.zwłoka = idx.ZwłokaKsiNaDzień(prms.Aktualny);

					decimal kwotaZob = prms.WgWartosciPLNHist ? worker.ZobowiazanieKsi(prms.Aktualny).Value : worker.ZobowiazanieKsiOpe(prms.Aktualny).Value;
					decimal kwotaNal = prms.WgWartosciPLNHist ? worker.NaleznoscKsi(prms.Aktualny).Value : worker.NaleznoscKsiOpe(prms.Aktualny).Value;

					Currency kwotaCalosc;
					if (prms.WgWartosciPLNHist)
						StanRozliczeniaRozrachunkuWorker.ObliczKsiKwotaZapisu(worker.RozrachunekIdx, out kwotaCalosc);
					else
						StanRozliczeniaRozrachunkuWorker.ObliczKsiKwotaOperacji(worker.RozrachunekIdx, out kwotaCalosc);

					kwotaCalosc = Currency.Abs(kwotaCalosc);
					
					switch (prms.Dokumenty)
					{
						case TypDokumentow.Należności:
							this.pozostaje = kwotaNal;
							this.kwotadokumentu = worker.PrzeliczWgZnaku(worker.NaleznoscSign(), delegate() { return kwotaCalosc; }, kwotaCalosc.Symbol).Value;
							break;

						case TypDokumentow.Zobowiązania:
							this.pozostaje = kwotaZob;
							this.kwotadokumentu = worker.PrzeliczWgZnaku(worker.ZobowiazanieSign(), delegate() { return kwotaCalosc; }, kwotaCalosc.Symbol).Value;
							break;

						default:
							this.pozostaje = kwotaNal - kwotaZob;
							this.kwotadokumentu = worker.PrzeliczWgZnaku(worker.NaleznoscSign() - worker.ZobowiazanieSign(), delegate() { return kwotaCalosc; }, kwotaCalosc.Symbol).Value;
							break;
					}
				}
			}


		public int CompareTo(IdxProxy idxProxy)
		{ return idxProxy != null ? Termin.CompareTo(idxProxy.Termin) : 1; }


		public RozrachunekIdx Idx
		{ get { return idx; } }

		public Date Termin
		{ get { return termin; } }

		public int Zwłoka
		{ get { return zwłoka; } }

		public Currency Pozostaje
		{ get { return pozostaje; } }

		public Currency KwotaDokumentu
		{ get { return kwotadokumentu; } }

			
		public int ClassIndex
		{
			get
			{
				if (zwłoka <= 0)
					return 0;

				for (int i = 0; i < okresy.Length; i++)
					if (zwłoka <= okresy[i])
						return i + 1;

				return okresy.Length + 1;
			}
		}
	}
	
	
	private class Kategoria
	{
		private readonly String title;
		private readonly List<IdxProxy> lista = new List<IdxProxy>();


		public Kategoria(String title)
		{ this.title = title; }

		public void Add(IdxProxy pds)
		{ lista.Add(pds); }

		public String Title
		{ get { return title; } }

		
		public IList<IdxProxy> Lista
		{
			get
			{
				lista.Sort();
				return lista;
			}
		}		
	}


	private String Nazwa(int index)
	{
		if (index == 0)
			return "Bieżące (terminowe)";
		else if (index == okresy.Length + 1)
			return "Ponad " + okresy[okresy.Length - 1] + " dni";
		else if (index == 1)
			return "Od 1 do " + okresy[0] + " dni";
		else
			return "Od " + (okresy[index - 2] + 1) + " do " + okresy[index - 1] + " dni";
	}


	private void OnContextLoad(object sender, EventArgs e)
	{
		wr.PodmiotOd = pars.Od;
		wr.PodmiotDo = pars.Do;
	    wr.TypRozliczenKsiegowy = pars.TypRozliczen == TypRozliczen.Księgowe;
    	wr.Waluta = pars.Waluta;
		wr.SetAktualneKonto(pars.AktualneKonto, pars.Aktualny);
		wr.SetFeature(wgWartościCechy, pars.WartośćCechy);

		//
		// NAGŁÓWEK RAPORTU
		//

        ReportHeader1["ODDZIAL"] = OParams.GetTitleItem();
		ReportHeader1["TYPROZLICZEN"] = pars.TypRozliczen == TypRozliczen.Kasowe ? "kasowych" : "księgowych";
		ReportHeader1["TYP"] = pars.Dokumenty == TypDokumentow.PerSaldo ? "per saldo" : (pars.Dokumenty == TypDokumentow.Należności ? "należności" : "zobowiązań");
		ReportHeader1["RODZAJ"] = pars.Rodzaj == RodzajDokumentów.Razem ? String.Empty : "|</STRONG>Rodzaj: <STRONG>" + pars.Rodzaj;
		ReportHeader1["ZAKRES"] = pars.Zakres == Zakres.Razem ? String.Empty : "|</STRONG>Zakres: <STRONG>" + pars.Zakres;
		ReportHeader1["WGCECHY"] = pars.Zakres != Zakres.Kontrahenci || pars.WartośćCechy == String.Empty ? String.Empty : String.Format("|</STRONG>{0}: <STRONG> {1}", wgWartościCechy, pars.WartośćCechy);
		ReportHeader1["KONTRAHENT"] = wr.GetTitleStringPodmiot();
		ReportHeader1["KONTO"] = wr.GetTitleStringKonto();
		ReportHeader1["WALUTA"] = wr.GetTitleStringWaluta(pars.WgWartosciPLNHist);

		//
		// QUERY
		//

		KasaModule kasa = KasaModule.GetInstance(dc);
		Soneta.Business.View view = null;

		if (pars.TypRozliczen == TypRozliczen.Kasowe)
		{
			//
			// -> rozliczenia kasowe:
			// - rachunki nierozliczone na dzień aktualności
			// - z odpowiednim okresem wystawienia
			// - z odpowiednim okresem księgowania
			//

			view = kasa.RozrachunkiIdx.Nierozliczone(null, pars.Okres, pars.Aktualny);

			if (pars.OkresKS != FromTo.All)
				view.Condition &= new FieldCondition.Contain("DataKsiegowania", pars.OkresKS);
		}
		else
		{
			//
			// -> rozliczenia księgowe:
			// - bez ograniczenia na rozliczenie kasowe
			// - odpowiednik wyszukiwania na widoku rozliczeń KS niezaksięgowanych
			//

			view = kasa.RozrachunkiIdx.CreateView();
			view.Condition = new FieldCondition.Contain("DataKsiegowania", pars.OkresKS * new FromTo(Date.MinValid + 1, Date.MaxValid - 1));

			if (pars.Okres != FromTo.All)
				view.Condition &= new FieldCondition.Contain("Data", pars.Okres);

			view.Condition &= new FieldCondition.Greater("DataOstatniegoKsi", pars.Aktualny) | new FieldCondition.Equal("DataRozliczenia", Date.MaxValue);
		}

		view.Condition &= zakresCondition();
		view.Condition &= rodzajCondition(kasa.RozrachunkiIdx);
      	view.Condition &= OParams.GetConditionIdx();

		StanRozliczeniaRozrachunkuWorker srrWorker = new StanRozliczeniaRozrachunkuWorker();
		srrWorker.StanRozliczenia = StanRozliczeniaRozrachunku.Nierozliczone;
		srrWorker.StanRozliczeniaKs = StanRozliczeniaRozrachunku.Nierozliczone;

		List<Kategoria> kategorie = new List<Kategoria>();
		for (int i = 0; i < okresy.Length + 2; i++)
			kategorie.Add(new Kategoria(Nazwa(i)));

		wr.SetFilter(view);

		foreach (RozrachunekIdx idx in view)
		{
			srrWorker.RozrachunekIdx = idx;

			IdxProxy pds = new IdxProxy(idx, srrWorker, pars);
			kategorie[pds.ClassIndex].Add(pds);
		}

		DataRepeater1.DataSource = kategorie;
	}


	//
	// FILTRY
	//


	private RowCondition zakresCondition()
	{
		switch (pars.Zakres)
		{
			case Zakres.Kontrahenci:
				return new FieldCondition.TypeOf("Podmiot", typeof(Soneta.CRM.Kontrahent));

			case Zakres.Pracownicy:
				return new FieldCondition.TypeOf("Podmiot", typeof(Soneta.Kadry.Pracownik));

			case Zakres.Urzędy:
				RowCondition condition = RowCondition.Empty;
				condition = new FieldCondition.TypeOf("Podmiot", typeof(Soneta.CRM.Kontrahent));
				condition |= new FieldCondition.TypeOf("Podmiot", typeof(Soneta.Kadry.Pracownik));
				return new RowCondition.Not(condition);

			default:
				return RowCondition.Empty;
		}
	}


	private RowCondition rodzajCondition(RozrachunkiIdx idxTable)
	{
		Boolean fNaleznosci = pars.Dokumenty != TypDokumentow.Zobowiązania;
		Boolean fZobowiazania = pars.Dokumenty != TypDokumentow.Należności;
		Boolean fZaplaty = pars.Rodzaj != RodzajDokumentów.Płatności;
		Boolean fPlatnosci = pars.Rodzaj != RodzajDokumentów.Zapłaty;

		return idxTable.ZakresEx(fNaleznosci && fPlatnosci, fZobowiazania && fPlatnosci, fZobowiazania && fZaplaty, fNaleznosci && fZaplaty);
	}


	//
	// Zarzadzanie kontekstem
	//


	private WydrukiRozrachunkowSessionProxy sProxy = null;


	private void OnContextLoading(Object sender, EventArgs args)
	{
		sProxy = WydrukiRozrachunkowSessionProxy.GetSingleDbInstance(dc.Context);
		dc.attachContext(sProxy.CloneContext(dc.Context));
	}


	protected override void OnUnload(EventArgs e)
	{
		WydrukiRozrachunkowSessionProxy.SmartDispose(ref sProxy);
		base.OnUnload(e);
	}

	
		</script>
	</head>

	<body>
		<form id="StrukturaWiekowaNaleznosciDokumenty" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" oncontextload="OnContextLoad" OnContextLoading="OnContextLoading" Landscape="true" />

			<cc1:ReportHeader ID="ReportHeader1" runat="server" ContextTypeName="Soneta.Business.OkresContext,Soneta.Business" DataMember0="Okres" DataMember1="Aktualny" DataMember2="OkresKS" 
				Title="Struktura wiekowa %TYP% dla wszystkich dokumentów|%ODDZIAL%</STRONG>Stan na dzień: <STRONG>{1}|</STRONG>Wg rozliczeń: <STRONG>%TYPROZLICZEN%|</STRONG> Za okres: <STRONG>{0}|</STRONG> Za okres KS: <STRONG>{2}%RODZAJ%%ZAKRES%%WGCECHY%%KONTRAHENT%%WALUTA%%KONTO%"
				/>

		<ea:DataRepeater ID="DataRepeater1" runat="server" Width="100%">

			<ea:SectionMarker ID="SectionMarker2" runat="server" />

			<p />
			<ea:DataLabel ID="DataLabel1" runat="server" DataMember="Title" />
			<ea:Grid ID="Grid1" runat="server" DataMember="Lista">
				<Columns>
					<ea:GridColumn Width="4" Align="Center" DataMember="#" Caption="Lp." runat="server" />
					<ea:GridColumn Width="11" Align="Center" DataMember="Termin" Caption="Termin" runat="server" />
					<ea:GridColumn Width="16" DataMember="Idx.Podmiot.Kod" Caption="Kod" NoWrap="True" EncodeHTML="True" runat="server" />
					<ea:GridColumn Width="40" DataMember="Idx.Podmiot.Nazwa" Caption="Nazwa" NoWrap="True" EncodeHTML="True" runat="server" />
					<ea:GridColumn Width="17" Align="Right" DataMember="KwotaDokumentu" Total="Sum" Caption="Kwota dokumentu" Format="{0:n}" runat="server" />
					<ea:GridColumn Width="17" Align="Right" DataMember="Pozostaje" Total="Sum" Caption="Pozostaje" Format="{0:n}" runat="server" />
					<ea:GridColumn Width="6" Align="Center" DataMember="Zwłoka" Caption="Zwł." runat="server" />
					<ea:GridColumn Width="11" Align="Center" DataMember="Idx.Data" Caption="Data" runat="server" />
					<ea:GridColumn Width="0" DataMember="Idx.Numer" Caption="Numer" NoWrap="True" runat="server" />
				</Columns>
			</ea:Grid>
			<ea:SectionMarker ID="SectionMarker1" runat="server" SectionType="Footer" />
		</ea:DataRepeater>

		<cc1:ReportFooter ID="ReportFooter1" runat="server">
			<Subtitles>
				<cc1:FooterSubtitle ID="FooterSubtitle1" runat="server" SubtitleType="Operator" />
				<cc1:FooterSubtitle ID="FooterSubtitle2" runat="server" Caption="Sporządził" SubtitleType="Podpis" />
				<cc1:FooterSubtitle ID="FooterSubtitle3" runat="server" Caption="Sprawdził" SubtitleType="Podpis" />
				<cc1:FooterSubtitle ID="FooterSubtitle4" runat="server" Caption="Zatwierdził" SubtitleType="Podpis" />
			</Subtitles>
		</cc1:ReportFooter>
		</form>
	</body>
</html>

